local assets =
{
	Asset("ANIM", "anim/magicpowerex.zip"),
    Asset("ATLAS", "images/inventoryimages/magicpower_mk2.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("magicpowerex")
    inst.AnimState:SetBuild("magicpowerex")
    inst.AnimState:PlayAnimation("idle",true)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "magicpower_mk2"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/magicpower_mk2.xml"
    inst:AddComponent("selfstacker")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("magicpower_mk2", fn, assets)